"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TLUserPreferences_exports = {};
__export(TLUserPreferences_exports, {
  USER_COLORS: () => USER_COLORS,
  defaultUserPreferences: () => defaultUserPreferences,
  getFreshUserPreferences: () => getFreshUserPreferences,
  getUserPreferences: () => getUserPreferences,
  setUserPreferences: () => setUserPreferences,
  userPrefersReducedMotion: () => userPrefersReducedMotion
});
module.exports = __toCommonJS(TLUserPreferences_exports);
var import_state = require("@tldraw/state");
var import_tlschema = require("@tldraw/tlschema");
var import_utils = require("@tldraw/utils");
var import_validate = require("@tldraw/validate");
var import_uniqueId = require("../utils/uniqueId");
const USER_DATA_KEY = "TLDRAW_USER_DATA_v3";
const userTypeValidator = import_validate.T.object({
  id: import_validate.T.string,
  name: import_validate.T.string.nullable().optional(),
  locale: import_validate.T.string.nullable().optional(),
  color: import_validate.T.string.nullable().optional(),
  colorScheme: import_validate.T.literalEnum("light", "dark", "system").optional(),
  animationSpeed: import_validate.T.number.nullable().optional(),
  edgeScrollSpeed: import_validate.T.number.nullable().optional(),
  isSnapMode: import_validate.T.boolean.nullable().optional(),
  isWrapMode: import_validate.T.boolean.nullable().optional(),
  isDynamicSizeMode: import_validate.T.boolean.nullable().optional(),
  isPasteAtCursorMode: import_validate.T.boolean.nullable().optional()
});
const Versions = {
  AddAnimationSpeed: 1,
  AddIsSnapMode: 2,
  MakeFieldsNullable: 3,
  AddEdgeScrollSpeed: 4,
  AddExcalidrawSelectMode: 5,
  AddDynamicSizeMode: 6,
  AllowSystemColorScheme: 7,
  AddPasteAtCursor: 8
};
const CURRENT_VERSION = Math.max(...Object.values(Versions));
function migrateSnapshot(data) {
  if (data.version < Versions.AddAnimationSpeed) {
    data.user.animationSpeed = 1;
  }
  if (data.version < Versions.AddIsSnapMode) {
    data.user.isSnapMode = false;
  }
  if (data.version < Versions.MakeFieldsNullable) {
  }
  if (data.version < Versions.AddEdgeScrollSpeed) {
    data.user.edgeScrollSpeed = 1;
  }
  if (data.version < Versions.AddExcalidrawSelectMode) {
    data.user.isWrapMode = false;
  }
  if (data.version < Versions.AllowSystemColorScheme) {
    if (data.user.isDarkMode === true) {
      data.user.colorScheme = "dark";
    } else if (data.user.isDarkMode === false) {
      data.user.colorScheme = "light";
    }
    delete data.user.isDarkMode;
  }
  if (data.version < Versions.AddDynamicSizeMode) {
    data.user.isDynamicSizeMode = false;
  }
  if (data.version < Versions.AddPasteAtCursor) {
    data.user.isPasteAtCursorMode = false;
  }
  data.version = CURRENT_VERSION;
}
const USER_COLORS = [
  "#FF802B",
  "#EC5E41",
  "#F2555A",
  "#F04F88",
  "#E34BA9",
  "#BD54C6",
  "#9D5BD2",
  "#7B66DC",
  "#02B1CC",
  "#11B3A3",
  "#39B178",
  "#55B467"
];
function getRandomColor() {
  return USER_COLORS[Math.floor(Math.random() * USER_COLORS.length)];
}
function userPrefersReducedMotion() {
  if (typeof window !== "undefined" && "matchMedia" in window) {
    return window.matchMedia?.("(prefers-reduced-motion: reduce)")?.matches ?? false;
  }
  return false;
}
const defaultUserPreferences = Object.freeze({
  name: "New User",
  locale: (0, import_tlschema.getDefaultTranslationLocale)(),
  color: getRandomColor(),
  edgeScrollSpeed: 1,
  animationSpeed: userPrefersReducedMotion() ? 0 : 1,
  isSnapMode: false,
  isWrapMode: false,
  isDynamicSizeMode: false,
  isPasteAtCursorMode: false,
  colorScheme: "system"
});
function getFreshUserPreferences() {
  return {
    id: (0, import_uniqueId.uniqueId)(),
    color: getRandomColor()
  };
}
function migrateUserPreferences(userData) {
  if (userData === null || typeof userData !== "object") {
    return getFreshUserPreferences();
  }
  if (!("version" in userData) || !("user" in userData) || typeof userData.version !== "number") {
    return getFreshUserPreferences();
  }
  const snapshot = (0, import_utils.structuredClone)(userData);
  migrateSnapshot(snapshot);
  try {
    return userTypeValidator.validate(snapshot.user);
  } catch (e) {
    return getFreshUserPreferences();
  }
}
function loadUserPreferences() {
  const userData = JSON.parse((0, import_utils.getFromLocalStorage)(USER_DATA_KEY) || "null") ?? null;
  return migrateUserPreferences(userData);
}
const globalUserPreferences = (0, import_state.atom)("globalUserData", null);
function storeUserPreferences() {
  (0, import_utils.setInLocalStorage)(
    USER_DATA_KEY,
    JSON.stringify({
      version: CURRENT_VERSION,
      user: globalUserPreferences.get()
    })
  );
}
function setUserPreferences(user) {
  userTypeValidator.validate(user);
  globalUserPreferences.set(user);
  storeUserPreferences();
  broadcastUserPreferencesChange();
}
const isTest = typeof process !== "undefined" && process.env.NODE_ENV === "test";
const channel = typeof BroadcastChannel !== "undefined" && !isTest ? new BroadcastChannel("tldraw-user-sync") : null;
channel?.addEventListener("message", (e) => {
  const data = e.data;
  if (data?.type === broadcastEventKey && data?.origin !== getBroadcastOrigin()) {
    globalUserPreferences.set(migrateUserPreferences(data.data));
  }
});
let _broadcastOrigin = null;
function getBroadcastOrigin() {
  if (_broadcastOrigin === null) {
    _broadcastOrigin = (0, import_uniqueId.uniqueId)();
  }
  return _broadcastOrigin;
}
const broadcastEventKey = "tldraw-user-preferences-change";
function broadcastUserPreferencesChange() {
  channel?.postMessage({
    type: broadcastEventKey,
    origin: getBroadcastOrigin(),
    data: {
      user: getUserPreferences(),
      version: CURRENT_VERSION
    }
  });
}
function getUserPreferences() {
  let prefs = globalUserPreferences.get();
  if (!prefs) {
    prefs = loadUserPreferences();
    setUserPreferences(prefs);
  }
  return prefs;
}
//# sourceMappingURL=TLUserPreferences.js.map
